//  CanvasMouseAdapter.java
// Olof 5 feb
// Jonas 13 feb

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;
import Agent;
import MobileHost;

public class CanvasMouseAdapter extends MouseAdapter {
  ShowMobileIPCanvas canvas;
  // Constructor
  public CanvasMouseAdapter(ShowMobileIPCanvas father) {
    super();
    this.canvas = father;
  }
  public void mousePressed(MouseEvent e) {
    Globals.last_x = e.getX();
    Globals.last_y = e.getY();
  }  
  public void mouseClicked(MouseEvent e) {
    
    if (e.getClickCount() >= 2) {           
      int i = Agent.whichAgent(Globals.last_x, Globals.last_y);
      if (i !=Globals.nbrOfFA + 1) { // Clicked on an Agent?
	if (! Globals.dialogExist[i]) {
	  Globals.dialogExist[i] = true;
	  Graphics g = canvas.getGraphics();  // Get the graphics in Canvas
	  Globals.Dialogs[i] = new AgentDialog(i, canvas.frame, g);
	  Globals.Dialogs[i].show();
	  Globals.Dialogs[i].setBounds(50, 200*i+50, 250, 175);
	}
	else {
	  Globals.Dialogs[i].setVisible(false);
	  Globals.Dialogs[i].show();
	}
      }
      else { // Mouseclick over Letter

	switch (Globals.whichThread) {
	case 1:
	  if (canvas.t.L.posInLetter() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t.L.letterDialog(); 
	  break;
	case 2:
	  for (int j=0; j<canvas.nbrOfNotifyThreads; j++){
	    if (canvas.t2[j].L.posInLetter() && 
		(Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t2[j].L.letterDialog(); 
	  }
	  break;
	case 3:
	  if (canvas.t3.L.posInLetter() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t3.L.letterDialog(); 
	  break;
	case 4:
	  if (canvas.t4.L.posInLetter() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t4.L.letterDialog(); 
	  break;
	case 5:
	  if (canvas.t5.L.posInLetter() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t5.L.letterDialog(); 
	  break;
	case 6:
	  if (canvas.t6.P.posInPackage() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t6.P.packageDialog(); 
	  break;
	case 8:
	  if (canvas.t8.L.posInLetter() && 
	      (Globals.actionAllowed || !Globals.contAllowed)) 
	    canvas.t8.L.letterDialog(); 
	  break;
	  
	}
      }
    }
  }
}
